# -*- coding: utf-8 -*-
"""r13.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1WMciecV2CdLNPNJ8OW2mc5rSrdikmko9
"""

import numpy as np
import matplotlib.pyplot as plt

# UWAGA: poniżej zdefiniowano globalne ustawienia związane z wyglądem rysunków,
# które wykorzystano do wygenerowania rysunków pokazanych w książce

from IPython import display
display.set_matplotlib_formats('svg') # Rysunki w formacie wektorowym
plt.rcParams.update({'font.size':14}) # Rozmiar czcionki



"""# Geometryczna interpretacja wektorów własnych"""

M = np.array([ [-1,1],
               [-1,2] ])

eigenvalues,eigenvectors = np.linalg.eig(M)
print(eigenvalues)

notEigenvectors = np.random.randn(2,2)

Mv = M @ eigenvectors
Mw = M @ notEigenvectors



_,axs = plt.subplots(1,2,figsize=(10,6))

axs[0].plot([0,eigenvectors[0,0]],[0,eigenvectors[1,0]],'k',linewidth=2,label='$v_1$')
axs[0].plot([0,Mv[0,0]],[0,Mv[1,0]],'k--',linewidth=2,label='$Mv_1$')

axs[0].plot([0,eigenvectors[0,1]],[0,eigenvectors[1,1]],'r',linewidth=2,label='$v_2$')
axs[0].plot([0,Mv[0,1]],[0,Mv[1,1]],'r--',linewidth=2,label='$Mv_2$')

axs[1].plot([0,notEigenvectors[0,0]],[0,notEigenvectors[1,0]],'k',linewidth=2,label='$w_1$')
axs[1].plot([0,Mw[0,0]],[0,Mw[1,0]],'k--',linewidth=2,label='$Mw_1$')

axs[1].plot([0,notEigenvectors[0,1]],[0,notEigenvectors[1,1]],'r',linewidth=2,label='$w_2$')
axs[1].plot([0,Mw[0,1]],[0,Mw[1,1]],'r--',linewidth=2,label='$Mw_2$')


for i in range(2):
  axs[i].axis('square')
  axs[i].set_xlim([-1.5,1.5])
  axs[i].set_ylim([-1.5,1.5])
  axs[i].grid()
  axs[i].legend()

plt.savefig('rys13.1.png',dpi=300)
plt.show()



"""# Znajdowanie wartości własnych"""

matrix = np.array([
             [1,2],
             [3,4]
             ])

# wyznaczam wartości własne
evals = np.linalg.eig(matrix)[0]
evals



"""# Znajdowanie wektorów własnych"""

evals,evecs = np.linalg.eig(matrix)
print(evals), print(evecs)



"""# Diagonalizacja macierzy"""

D = np.diag(evals)
D

LHS = matrix @ evecs
RHS = evecs @ D


print('Lewa strona:')
print(LHS)

print(f'\nPrawa strona:')
print(RHS)



"""# Specjalne własności macierzy symetrycznych"""

# losowa macierz symetryczna
A = np.random.randint(-3,4,(3,3))
A = A.T@A

# rozkład według wartości własnych
L,V = np.linalg.eig(A)

# iloczyny skalarne wszystkich par
print( np.dot(V[:,0],V[:,1]) )
print( np.dot(V[:,0],V[:,2]) )
print( np.dot(V[:,1],V[:,2]) )

np.round( V.T@V ,10)

A = np.array([[-3, -3, 0],
              [ 3, -2, 3],
              [ 0,  1, 2]])

# rozkład według wartości własnych
L,V = np.linalg.eig(A)
L.reshape(-1,1) # wyświetlam jako wektor kolumnowy

# macierz symetryczna
A = np.array([[-3, -3, 0],
              [-3, -2, 1],
              [ 0,  1, 2]])


# rozkład według wartości własnych

L,V = np.linalg.eig(A)
L.reshape(-1,1) # wyświetlam jako wektor kolumnowy



"""# Rozkład według wartości własnych macierzy osobliwych"""

# macierz osobliwa
A = np.array([[1,4,7],
              [2,5,8],
              [3,6,9]])

# jej rozkład własny
L,V = np.linalg.eig(A)


print( f'Rząd = {np.linalg.matrix_rank(A)}\n' )
print('Wartości własne: '), print(L.round(2)), print(' ')
print('Wektory własne:'), print(V.round(2))

M = np.random.randn(5,3) @ np.random.randn(3,5)
M = M.T@M

np.linalg.eig(M)[0].reshape(-1,1).round(3)



"""# Forma kwadratowa"""

A = np.array([ [2,4],[0,3] ])
print('Wartości własne: ')
print(np.linalg.eig(A)[0])

x,y = np.random.randn(2)
print(f'\nLosowa forma kwadratowa:')
A[0,0]*x**2 + (A[1,0]+A[0,1])*x*y + A[1,1]*y**2

A = np.array([ [-9,4],[3,9] ])
print('Wartości własne: ')
print(np.linalg.eig(A)[0])

x,y = np.random.randn(2)
print(f'\nLosowa forma kwadratowa:')
A[0,0]*x**2 + (A[1,0]+A[0,1])*x*y + A[1,1]*y**2



"""# Uogólniony rozkład według wartości własnych"""

# tworzę skorelowane ze sobą macierze
A = np.random.randn(4,4)
A = A@A.T
B = np.random.randn(4,4)
B = B@B.T + A/10

# uogólniony rozkład według wartości własnych
from scipy.linalg import eigh
evals,evecs = eigh(A,B)



"""# Ćwiczenie 1."""

# tworzę macierz
A = np.random.randn(5,5)
A = A.T@A

# obliczam jej odwrotność
Ai = np.linalg.inv(A)

# wartości własne
eigvals_A  = np.linalg.eig(A)[0]
eigvals_Ai = np.linalg.eig(Ai)[0]

# porównanie (uwaga: pomocne jest sortowanie!)
print('Wartości własne  A:')
print(np.sort(eigvals_A))

print(' ')
print('Wartości własne inv(A):')
print(np.sort(eigvals_Ai))

print(' ')
print('Odwrotności wartości własnych inv(A):')
print(np.sort(1/eigvals_Ai))



"""# Ćwiczenie 2."""

# macierz
M = np.array([ [-1,1],
               [-1,2] ])

# wartości i wektory własne
eigenvalues,eigenvectors = np.linalg.eig(M)

# jakiś losowy wektor
notEigenvectors = np.random.randn(2,2)

# mnożenie w celu utworzenia nowych wektorów
Mv = M @ eigenvectors
Mw = M @ notEigenvectors



## wykres
_,axs = plt.subplots(1,2,figsize=(10,6))

# wektory własne
axs[0].plot([0,eigenvectors[0,0]],[0,eigenvectors[0,1]],'k',linewidth=2,label='$v_1$')
axs[0].plot([0,Mv[0,0]],[0,Mv[0,1]],'k--',linewidth=2,label='$Mv_1$')

axs[0].plot([0,eigenvectors[1,0]],[0,eigenvectors[1,1]],'r',linewidth=2,label='$v_2$')
axs[0].plot([0,Mv[1,0]],[0,Mv[1,1]],'r--',linewidth=2,label='$Mv_2$')

# inne wektory
axs[1].plot([0,notEigenvectors[0,0]],[0,notEigenvectors[0,1]],'k',linewidth=2,label='$w_1$')
axs[1].plot([0,Mw[0,0]],[0,Mw[0,1]],'k--',linewidth=2,label='$Mw_1$')

axs[1].plot([0,notEigenvectors[1,0]],[0,notEigenvectors[1,1]],'r',linewidth=2,label='$w_2$')
axs[1].plot([0,Mw[1,0]],[0,Mw[1,1]],'r--',linewidth=2,label='$Mw_2$')


for i in range(2):
  axs[i].axis('square')
  axs[i].set_xlim([-1.5,1.5])
  axs[i].set_ylim([-1.5,1.5])
  axs[i].grid()
  axs[i].legend()

plt.show()



"""# Ćwiczenie 3."""

# w poleceniu nie określono rozmiaru macierzy, wykorzystam N=5
N = 5

# macierz do przechowywania miar dokładności rekonstrukcji
reconAcc = np.zeros(4)


# tworzę symetryczną macierz losowych liczb całkowitych
A = np.random.randn(N,N)
A = np.round( A.T@A )

# diagonalizacja
d,V  = np.linalg.eig(A)
D    = np.diag(d)

# dokładność rekonstrukcji
# pamiętaj, że inv(V)=V.T!
Arecon = V @ D @ V.T
print(np.round( A-Arecon ,4))

reconAcc[0] = np.sqrt(np.sum( (A-Arecon)**2 ))
print(f'\nOdległość Frobeniusa: {reconAcc[0]}')

# tworzę macierz z wartościami własnymi w losowej kolejności
Dtild = np.diag( d[np.random.permutation(N)] )

# dokładność rekonstrukcji
Arecon = V @ Dtild @ V.T
print(np.round( A-Arecon ,4))

reconAcc[1] = np.sqrt(np.sum( (A-Arecon)**2 ))
print(f'\nOdległość Frobeniusa: {reconAcc[1]}')

### zamiana dwóch największych wartości własnych
evals_sort_idx = np.argsort(d)
i = evals_sort_idx[np.r_[np.arange(N-2),N-1,N-2]][::-1]

Dtild = np.diag( d[i] )

# dokładność rekonstrukcji
Arecon = V @ Dtild @ V.T
print(np.round( A-Arecon ,4))

reconAcc[2] = np.sqrt(np.sum( (A-Arecon)**2 ))
print(f'\nOdległość Frobeniusa: {reconAcc[2]}')

### zamiana dwóch najmniejszych wartości własnych
evals_sort_idx = np.argsort(d)
i = evals_sort_idx[np.r_[1,0,np.arange(2,N)]][::-1]

Dtild = np.diag( d[i] )

# dokładność rekonstrukcji
Arecon = V @ Dtild @ V.T
print(np.round( A-Arecon ,4))

reconAcc[3] = np.sqrt(np.sum( (A-Arecon)**2 ))
print(f'\nOdległość Frobeniusa: {reconAcc[3]}')

# wykres

plt.figure(figsize=(8,6))

plt.bar(range(4),reconAcc)
plt.xticks(range(4),labels=['Brak','Wszystkie','Dwie\nnajwiększe','Dwie\nnajmniejsze'])
plt.ylabel('Odległość Frobeniusa do oryginalnej macierzy')
plt.xlabel('Rodzaj zmiany kolejności wartości własnych')
plt.title('Dokładność rekonstrukcji')

plt.savefig('rys13.3.png',dpi=300, bbox_inches='tight')
plt.show()



"""# Ćwiczenie 4."""

nIter = 123
matsize = 42
evals = np.zeros((nIter,matsize),dtype=complex)

# tworzę macierze i przeskalowuję ich wartości własne
for i in range(nIter):
  A = np.random.randn(matsize,matsize)
  evals[i,:] = np.linalg.eig(A)[0] / np.sqrt(matsize)



# wykres
plt.figure(figsize=(6,6))

plt.plot(np.real(evals),np.imag(evals),'ko',markerfacecolor='white')
plt.xlim([-1.5,1.5])
plt.ylim([-1.5,1.5])
plt.xlabel('Część rzeczywista')
plt.ylabel('Część urojona')
plt.savefig('rys13.4.png',dpi=300,bbox_inches='tight')
plt.show()



"""# Ćwiczenie 5."""

from scipy.linalg import null_space


# tworzę macierz symetryczną
N = 3
A = np.random.randn(N,N)
A = A@A.T

# rozkład według wartości własnych
evals,evecs = np.linalg.eig(A)

# porównuję wektory własne z N(A-lI)
for i in range(N):

  # wektor bazowy jądra przesuniętej macierzy
  nullV = null_space( A-evals[i]*np.eye(N) )

  # sprawdzam podobieństwo za pomocą korelacji
  r = np.corrcoef(nullV.T,evecs[[i],:])[0,1]

  # i wyświetlam wartość bezwzględną r
  print(f'Współczynnik korelacji N(A-lI) i evec {i}: {np.abs(r):.2f}')



"""# Ćwiczenie 6."""

# tworzę macierz lambda zawierającą na przekątnej dodatnie wartości
Lambda = np.diag( np.random.rand(4)*5 )

# wyznaczam macierz Q
Q,_ = np.linalg.qr( np.random.randn(4,4) )

# odtwarzam macierz
A = Q @ Lambda @ Q.T

# macierz minus jej transpozycja powinna dawać zero
np.round( A-A.T ,5)

# sprawdzam wartości własne (pomocne będzie sortowanie!)
print(np.sort(np.diag(Lambda)))
print(np.sort(np.linalg.eig(A)[0]))



"""# Ćwiczenie 7."""

# Skorzystaj z kodu ćwiczenia 4. z rozdziału 12.



"""# Ćwiczenie 8."""

# macierz korelacji
R = np.array([[ 1,.2,.9],
              [.2, 1,.3],
              [.9,.3, 1] ])

# rozkład według wartości własnych
d,V = np.linalg.eig(R)
D = np.diag(d)

# tworzę nowe dane z określoną macierzą korelacji
X = V @ np.sqrt(D) @ np.random.randn(3,10000)

np.corrcoef(X)



"""# Ćwiczenie 9."""

# wybielanie
Y = X.T @ V @ np.linalg.inv(np.sqrt(D))

# sprawdzenie korelacji
np.round( np.corrcoef(Y.T) ,3)



"""# Ćwiczenie 10."""

# dwie macierze symetryczne i ich rozkład według wartości własnych
n = 5
A = np.random.randn(n,n)
A = A.T@A
B = np.random.randn(n,n)
B = B.T@B

evals,evecs = eigh( A,B )

# macierz wektorów własnych razy jej transpozycja
VV  = evecs.T @ evecs
VBV = evecs.T @ B @ evecs


# wykres
_,axs = plt.subplots(1,2,figsize=(10,6))

axs[0].imshow(VV,cmap='gray')
axs[0].set_title('$\mathbf{V}^T\mathbf{V}$')

axs[1].imshow(VBV,cmap='gray')
axs[1].set_title('$\mathbf{V}^T\mathbf{B}\mathbf{V}$')

plt.savefig('rys13.5.png',dpi=300)
plt.show()



"""# Ćwiczenie 11."""

# tworzę macierz
A = np.random.randint(-14,15,(4,4))


# diagonalizuję
d,V = np.linalg.eig(A)
V   = V*np.pi
D   = np.diag(d)
Vi  = np.linalg.inv(V)


# sprawdzam dokładność rekonstrukcji
print('Różnica między zrekonstruowaną i oryginalną macierzą:')
print( np.round(V@D@Vi - A,3) )
print(' ')

# normy wektorów własnych
for i in range(A.shape[0]):
  norm = np.sqrt(np.sum(V[:,1]*np.conj(V[:,1])))
  print(f'Norma wektora własnego {i} go {norm}')


# skalowanie V nie ma znaczenia, ponieważ pozbywamy się skalara mnożąc przez macierz odwrotną

## to samo dla macierzy symetrycznej
# zamiast odwrotności stosuję transpozycję

# tworzę macierz
A = np.random.randint(-14,15,(4,4))
A = A.T@A


# diagonalizuję
d,V = np.linalg.eig(A)
V = V*np.pi
D = np.diag(d)
Vi = V.T


# sprawdzam dokładność rekonstrukcji
print('Różnica między zrekonstruowaną i oryginalną macierzą:')
print( np.round(V@D@Vi - A,3) )
print(' ')

# normy wektorów własnych
for i in range(A.shape[0]):
  norm = np.sqrt(np.sum(V[:,1]*np.conj(V[:,1])))
  print(f'Norma wektora własnego {i} go {norm}')


# skalowanie v ma znaczenie, ponieważ nie wykonujemy jawnego odwracania V!

